package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.oracle.MethodInfo;

public class Marshaller_o_k_s_p_d_o_MethodInfo_1_Impl implements GeneratedMarshaller<MethodInfo> {
  private MethodInfo[] EMPTY_ARRAY = new MethodInfo[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public MethodInfo[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String MethodInfo_String_name(MethodInfo instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::name;
  }-*/;

  native static void MethodInfo_String_name(MethodInfo instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::name = value;
  }-*/;

  native static List MethodInfo_List_params(MethodInfo instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::params;
  }-*/;

  native static void MethodInfo_List_params(MethodInfo instance, List<String> value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::params = value;
  }-*/;

  native static String MethodInfo_String_returnClassType(MethodInfo instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::returnClassType;
  }-*/;

  native static void MethodInfo_String_returnClassType(MethodInfo instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::returnClassType = value;
  }-*/;

  native static String MethodInfo_String_parametricReturnType(MethodInfo instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::parametricReturnType;
  }-*/;

  native static void MethodInfo_String_parametricReturnType(MethodInfo instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::parametricReturnType = value;
  }-*/;

  native static String MethodInfo_String_genericType(MethodInfo instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::genericType;
  }-*/;

  native static void MethodInfo_String_genericType(MethodInfo instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.MethodInfo::genericType = value;
  }-*/;

  public MethodInfo demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MethodInfo.class, objId);
    }
    MethodInfo entity = new MethodInfo();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": MethodInfo_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "params": a1.setAssumedElementType("java.lang.String");
        MethodInfo_List_params(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "returnClassType": MethodInfo_String_returnClassType(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "parametricReturnType": MethodInfo_String_parametricReturnType(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "genericType": MethodInfo_String_genericType(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(MethodInfo a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.MethodInfo") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "params") + "\":") + java_util_List.marshall(a0.getParams(), a1)) + ",\"") + "returnClassType") + "\":") + java_lang_String.marshall(a0.getReturnClassType(), a1)) + ",\"") + "parametricReturnType") + "\":") + java_lang_String.marshall(a0.getParametricReturnType(), a1)) + ",\"") + "genericType") + "\":") + java_lang_String.marshall(a0.getGenericType(), a1)) + "}");
  }

  private void lazyInit() {

  }
}