package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModelField.FIELD_CLASS_TYPE;
import org.kie.soup.project.datamodel.oracle.ModelField.FIELD_ORIGIN;

public class Marshaller_o_k_s_p_d_o_ModelField_1_Impl implements GeneratedMarshaller<ModelField> {
  private ModelField[] EMPTY_ARRAY = new ModelField[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<FieldAccessorsAndMutators> org_kie_soup_project_datamodel_oracle_FieldAccessorsAndMutators = null;
  private Marshaller<FIELD_CLASS_TYPE> org_kie_soup_project_datamodel_oracle_ModelField_erraiD_FIELD_erraiU_CLASS_erraiU_TYPE = null;
  private Marshaller<FIELD_ORIGIN> org_kie_soup_project_datamodel_oracle_ModelField_erraiD_FIELD_erraiU_ORIGIN = null;
  public ModelField[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String ModelField_String_name(ModelField instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.ModelField::name;
  }-*/;

  native static void ModelField_String_name(ModelField instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.ModelField::name = value;
  }-*/;

  native static String ModelField_String_className(ModelField instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.ModelField::className;
  }-*/;

  native static void ModelField_String_className(ModelField instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.ModelField::className = value;
  }-*/;

  native static FieldAccessorsAndMutators ModelField_FieldAccessorsAndMutators_accessorsAndMutators(ModelField instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.ModelField::accessorsAndMutators;
  }-*/;

  native static void ModelField_FieldAccessorsAndMutators_accessorsAndMutators(ModelField instance, FieldAccessorsAndMutators value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.ModelField::accessorsAndMutators = value;
  }-*/;

  native static String ModelField_String_type(ModelField instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.ModelField::type;
  }-*/;

  native static void ModelField_String_type(ModelField instance, String value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.ModelField::type = value;
  }-*/;

  native static FIELD_CLASS_TYPE ModelField_FIELD_CLASS_TYPE_classType(ModelField instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.ModelField::classType;
  }-*/;

  native static void ModelField_FIELD_CLASS_TYPE_classType(ModelField instance, FIELD_CLASS_TYPE value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.ModelField::classType = value;
  }-*/;

  native static FIELD_ORIGIN ModelField_FIELD_ORIGIN_fieldOrigin(ModelField instance) /*-{
    return instance.@org.kie.soup.project.datamodel.oracle.ModelField::fieldOrigin;
  }-*/;

  native static void ModelField_FIELD_ORIGIN_fieldOrigin(ModelField instance, FIELD_ORIGIN value) /*-{
    instance.@org.kie.soup.project.datamodel.oracle.ModelField::fieldOrigin = value;
  }-*/;

  public ModelField demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ModelField.class, objId);
    }
    ModelField entity = new ModelField();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": ModelField_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "className": ModelField_String_className(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "accessorsAndMutators": ModelField_FieldAccessorsAndMutators_accessorsAndMutators(entity, objVal.isObject() != null ? Enum.valueOf(FieldAccessorsAndMutators.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(FieldAccessorsAndMutators.class, objVal.isString().stringValue()) : null);
        break;
        case "type": ModelField_String_type(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "classType": ModelField_FIELD_CLASS_TYPE_classType(entity, objVal.isObject() != null ? Enum.valueOf(FIELD_CLASS_TYPE.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(FIELD_CLASS_TYPE.class, objVal.isString().stringValue()) : null);
        break;
        case "fieldOrigin": ModelField_FIELD_ORIGIN_fieldOrigin(entity, objVal.isObject() != null ? Enum.valueOf(FIELD_ORIGIN.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(FIELD_ORIGIN.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(ModelField a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.ModelField") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + ",\"") + "accessorsAndMutators") + "\":") + (a0.getAccessorsAndMutators() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getAccessorsAndMutators().name()) + "\"}" : "null")) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "classType") + "\":") + (a0.getClassType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.ModelField$FIELD_CLASS_TYPE") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getClassType().name()) + "\"}" : "null")) + ",\"") + "fieldOrigin") + "\":") + (ModelField_FIELD_ORIGIN_fieldOrigin(a0) != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.soup.project.datamodel.oracle.ModelField$FIELD_ORIGIN") + "\",\"") + "^EnumStringValue") + "\":\"") + ModelField_FIELD_ORIGIN_fieldOrigin(a0).name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_kie_soup_project_datamodel_oracle_FieldAccessorsAndMutators == null) {
      org_kie_soup_project_datamodel_oracle_FieldAccessorsAndMutators = Marshalling.getMarshaller(FieldAccessorsAndMutators.class);
    }
    if (org_kie_soup_project_datamodel_oracle_ModelField_erraiD_FIELD_erraiU_CLASS_erraiU_TYPE == null) {
      org_kie_soup_project_datamodel_oracle_ModelField_erraiD_FIELD_erraiU_CLASS_erraiU_TYPE = Marshalling.getMarshaller(FIELD_CLASS_TYPE.class);
    }
    if (org_kie_soup_project_datamodel_oracle_ModelField_erraiD_FIELD_erraiU_ORIGIN == null) {
      org_kie_soup_project_datamodel_oracle_ModelField_erraiD_FIELD_erraiU_ORIGIN = Marshalling.getMarshaller(FIELD_ORIGIN.class);
    }
  }
}