package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;

public class Marshaller_o_k_w_c_d_a_d_NOPDomainObject_1_Impl implements GeneratedMarshaller<NOPDomainObject> {
  private NOPDomainObject[] EMPTY_ARRAY = new NOPDomainObject[0];
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public NOPDomainObject[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Set NOPDomainObject_Set_stunnerLabels(NOPDomainObject instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.NOPDomainObject::stunnerLabels;
  }-*/;

  native static void NOPDomainObject_Set_stunnerLabels(NOPDomainObject instance, Set<String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.NOPDomainObject::stunnerLabels = value;
  }-*/;

  public NOPDomainObject demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NOPDomainObject.class, objId);
    }
    NOPDomainObject entity = new NOPDomainObject();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "stunnerLabels": a1.setAssumedElementType("java.lang.String");
        NOPDomainObject_Set_stunnerLabels(entity, java_util_Set.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(NOPDomainObject a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.NOPDomainObject") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "stunnerLabels") + "\":") + java_util_Set.marshall(a0.getStunnerLabels(), a1)) + "}");
  }

  private void lazyInit() {

  }
}