package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;

public class Marshaller_o_k_w_c_d_a_d_m_DecisionTable_1_Impl implements GeneratedMarshaller<DecisionTable> {
  private DecisionTable[] EMPTY_ARRAY = new DecisionTable[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<HitPolicy> org_kie_workbench_common_dmn_api_definition_model_HitPolicy = null;
  private Marshaller<BuiltinAggregator> org_kie_workbench_common_dmn_api_definition_model_BuiltinAggregator = null;
  private Marshaller<DecisionTableOrientation> org_kie_workbench_common_dmn_api_definition_model_DecisionTableOrientation = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<QName> org_kie_workbench_common_dmn_api_property_dmn_QName = null;
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public DecisionTable[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List DecisionTable_List_input(DecisionTable instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DecisionTable::input;
  }-*/;

  native static void DecisionTable_List_input(DecisionTable instance, List<InputClause> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DecisionTable::input = value;
  }-*/;

  native static List DecisionTable_List_output(DecisionTable instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DecisionTable::output;
  }-*/;

  native static void DecisionTable_List_output(DecisionTable instance, List<OutputClause> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DecisionTable::output = value;
  }-*/;

  native static List DecisionTable_List_rule(DecisionTable instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DecisionTable::rule;
  }-*/;

  native static void DecisionTable_List_rule(DecisionTable instance, List<DecisionRule> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DecisionTable::rule = value;
  }-*/;

  native static List Expression_List_componentWidths(Expression instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Expression::componentWidths;
  }-*/;

  native static void Expression_List_componentWidths(Expression instance, List<Double> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Expression::componentWidths = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public DecisionTable demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DecisionTable.class, objId);
    }
    DecisionTable entity = new DecisionTable();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "input": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.InputClause");
        DecisionTable_List_input(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "output": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.OutputClause");
        DecisionTable_List_output(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "rule": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.DecisionRule");
        DecisionTable_List_rule(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "hitPolicy": entity.setHitPolicy(objVal.isObject() != null ? Enum.valueOf(HitPolicy.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(HitPolicy.class, objVal.isString().stringValue()) : null);
        break;
        case "aggregation": entity.setAggregation(objVal.isObject() != null ? Enum.valueOf(BuiltinAggregator.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(BuiltinAggregator.class, objVal.isString().stringValue()) : null);
        break;
        case "preferredOrientation": entity.setPreferredOrientation(objVal.isObject() != null ? Enum.valueOf(DecisionTableOrientation.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(DecisionTableOrientation.class, objVal.isString().stringValue()) : null);
        break;
        case "outputLabel": entity.setOutputLabel(java_lang_String.demarshall(objVal, a1));
        break;
        case "typeRef": entity.setTypeRef(org_kie_workbench_common_dmn_api_property_dmn_QName.demarshall(objVal, a1));
        break;
        case "componentWidths": a1.setAssumedElementType("java.lang.Double");
        Expression_List_componentWidths(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DecisionTable a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.DecisionTable") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "input") + "\":") + java_util_List.marshall(a0.getInput(), a1)) + ",\"") + "output") + "\":") + java_util_List.marshall(a0.getOutput(), a1)) + ",\"") + "rule") + "\":") + java_util_List.marshall(a0.getRule(), a1)) + ",\"") + "hitPolicy") + "\":") + (a0.getHitPolicy() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.HitPolicy") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getHitPolicy().name()) + "\"}" : "null")) + ",\"") + "aggregation") + "\":") + (a0.getAggregation() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getAggregation().name()) + "\"}" : "null")) + ",\"") + "preferredOrientation") + "\":") + (a0.getPreferredOrientation() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getPreferredOrientation().name()) + "\"}" : "null")) + ",\"") + "outputLabel") + "\":") + java_lang_String.marshall(a0.getOutputLabel(), a1)) + ",\"") + "typeRef") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_QName.marshall(a0.getTypeRef(), a1)) + ",\"") + "componentWidths") + "\":") + java_util_List.marshall(a0.getComponentWidths(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_definition_model_HitPolicy == null) {
      org_kie_workbench_common_dmn_api_definition_model_HitPolicy = Marshalling.getMarshaller(HitPolicy.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_BuiltinAggregator == null) {
      org_kie_workbench_common_dmn_api_definition_model_BuiltinAggregator = Marshalling.getMarshaller(BuiltinAggregator.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DecisionTableOrientation == null) {
      org_kie_workbench_common_dmn_api_definition_model_DecisionTableOrientation = Marshalling.getMarshaller(DecisionTableOrientation.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_QName == null) {
      org_kie_workbench_common_dmn_api_property_dmn_QName = Marshalling.getMarshaller(QName.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}