package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.Artifact;
import org.kie.workbench.common.dmn.api.definition.model.BusinessContextElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ElementCollection;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;

public class Marshaller_o_k_w_c_d_a_d_m_Definitions_1_Impl implements GeneratedMarshaller<Definitions> {
  private Definitions[] EMPTY_ARRAY = new Definitions[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<ExpressionLanguage> org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Text> org_kie_workbench_common_dmn_api_property_dmn_Text = null;
  private Marshaller<Name> org_kie_workbench_common_dmn_api_property_dmn_Name = null;
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public Definitions[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List Definitions_List__import(Definitions instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::_import;
  }-*/;

  native static void Definitions_List__import(Definitions instance, List<Import> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::_import = value;
  }-*/;

  native static List Definitions_List_itemDefinition(Definitions instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::itemDefinition;
  }-*/;

  native static void Definitions_List_itemDefinition(Definitions instance, List<ItemDefinition> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::itemDefinition = value;
  }-*/;

  native static List Definitions_List_drgElement(Definitions instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::drgElement;
  }-*/;

  native static void Definitions_List_drgElement(Definitions instance, List<DRGElement> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::drgElement = value;
  }-*/;

  native static List Definitions_List_artifact(Definitions instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::artifact;
  }-*/;

  native static void Definitions_List_artifact(Definitions instance, List<Artifact> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::artifact = value;
  }-*/;

  native static List Definitions_List_elementCollection(Definitions instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::elementCollection;
  }-*/;

  native static void Definitions_List_elementCollection(Definitions instance, List<ElementCollection> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::elementCollection = value;
  }-*/;

  native static List Definitions_List_businessContextElement(Definitions instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::businessContextElement;
  }-*/;

  native static void Definitions_List_businessContextElement(Definitions instance, List<BusinessContextElement> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Definitions::businessContextElement = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public Definitions demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Definitions.class, objId);
    }
    Definitions entity = new Definitions();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "_import": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.Import");
        Definitions_List__import(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "itemDefinition": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.ItemDefinition");
        Definitions_List_itemDefinition(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "drgElement": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.DRGElement");
        Definitions_List_drgElement(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "artifact": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.Artifact");
        Definitions_List_artifact(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "elementCollection": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.ElementCollection");
        Definitions_List_elementCollection(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "businessContextElement": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.BusinessContextElement");
        Definitions_List_businessContextElement(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "expressionLanguage": entity.setExpressionLanguage(org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage.demarshall(objVal, a1));
        break;
        case "typeLanguage": entity.setTypeLanguage(java_lang_String.demarshall(objVal, a1));
        break;
        case "namespace": entity.setNamespace(org_kie_workbench_common_dmn_api_property_dmn_Text.demarshall(objVal, a1));
        break;
        case "exporter": entity.setExporter(java_lang_String.demarshall(objVal, a1));
        break;
        case "exporterVersion": entity.setExporterVersion(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(org_kie_workbench_common_dmn_api_property_dmn_Name.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Definitions a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.Definitions") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "_import") + "\":") + java_util_List.marshall(Definitions_List__import(a0), a1)) + ",\"") + "itemDefinition") + "\":") + java_util_List.marshall(a0.getItemDefinition(), a1)) + ",\"") + "drgElement") + "\":") + java_util_List.marshall(a0.getDrgElement(), a1)) + ",\"") + "artifact") + "\":") + java_util_List.marshall(a0.getArtifact(), a1)) + ",\"") + "elementCollection") + "\":") + java_util_List.marshall(a0.getElementCollection(), a1)) + ",\"") + "businessContextElement") + "\":") + java_util_List.marshall(a0.getBusinessContextElement(), a1)) + ",\"") + "expressionLanguage") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage.marshall(a0.getExpressionLanguage(), a1)) + ",\"") + "typeLanguage") + "\":") + java_lang_String.marshall(a0.getTypeLanguage(), a1)) + ",\"") + "namespace") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Text.marshall(a0.getNamespace(), a1)) + ",\"") + "exporter") + "\":") + java_lang_String.marshall(a0.getExporter(), a1)) + ",\"") + "exporterVersion") + "\":") + java_lang_String.marshall(a0.getExporterVersion(), a1)) + ",\"") + "name") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Name.marshall(a0.getName(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage == null) {
      org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage = Marshalling.getMarshaller(ExpressionLanguage.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Text == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Text = Marshalling.getMarshaller(Text.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Name == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Name = Marshalling.getMarshaller(Name.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}