package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;

public class Marshaller_o_k_w_c_d_a_d_m_ImportPMML_1_Impl implements GeneratedMarshaller<ImportPMML> {
  private ImportPMML[] EMPTY_ARRAY = new ImportPMML[0];
  private Marshaller<Name> org_kie_workbench_common_dmn_api_property_dmn_Name = null;
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<LocationURI> org_kie_workbench_common_dmn_api_property_dmn_LocationURI = null;
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ImportPMML[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Name ImportPMML_Name_wrapped(ImportPMML instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.ImportPMML::wrapped;
  }-*/;

  native static void ImportPMML_Name_wrapped(ImportPMML instance, Name value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.ImportPMML::wrapped = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public ImportPMML demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ImportPMML.class, objId);
    }
    ImportPMML entity = new ImportPMML();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "wrapped": ImportPMML_Name_wrapped(entity, org_kie_workbench_common_dmn_api_property_dmn_Name.demarshall(objVal, a1));
        break;
        case "modelCount": entity.setModelCount(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "namespace": entity.setNamespace(java_lang_String.demarshall(objVal, a1));
        break;
        case "locationURI": entity.setLocationURI(org_kie_workbench_common_dmn_api_property_dmn_LocationURI.demarshall(objVal, a1));
        break;
        case "importType": entity.setImportType(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(org_kie_workbench_common_dmn_api_property_dmn_Name.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ImportPMML a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.ImportPMML") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "wrapped") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Name.marshall(ImportPMML_Name_wrapped(a0), a1)) + ",\"") + "modelCount") + "\":") + java_lang_Integer.marshall(a0.getModelCount(), a1)) + ",\"") + "namespace") + "\":") + java_lang_String.marshall(a0.getNamespace(), a1)) + ",\"") + "locationURI") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_LocationURI.marshall(a0.getLocationURI(), a1)) + ",\"") + "importType") + "\":") + java_lang_String.marshall(a0.getImportType(), a1)) + ",\"") + "name") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Name.marshall(a0.getName(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_Name == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Name = Marshalling.getMarshaller(Name.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_LocationURI == null) {
      org_kie_workbench_common_dmn_api_property_dmn_LocationURI = Marshalling.getMarshaller(LocationURI.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}