package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.ConstraintTypeProperty;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;

public class Marshaller_o_k_w_c_d_a_d_m_InputClauseUnaryTests_1_Impl implements GeneratedMarshaller<InputClauseUnaryTests> {
  private InputClauseUnaryTests[] EMPTY_ARRAY = new InputClauseUnaryTests[0];
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Text> org_kie_workbench_common_dmn_api_property_dmn_Text = null;
  private Marshaller<ConstraintTypeProperty> org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public InputClauseUnaryTests[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Id InputClauseUnaryTests_Id_id(InputClauseUnaryTests instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests::id;
  }-*/;

  native static void InputClauseUnaryTests_Id_id(InputClauseUnaryTests instance, Id value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests::id = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public InputClauseUnaryTests demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(InputClauseUnaryTests.class, objId);
    }
    InputClauseUnaryTests entity = new InputClauseUnaryTests();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": InputClauseUnaryTests_Id_id(entity, org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "text": entity.setText(org_kie_workbench_common_dmn_api_property_dmn_Text.demarshall(objVal, a1));
        break;
        case "constraintTypeProperty": entity.setConstraintTypeProperty(org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(InputClauseUnaryTests a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "text") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Text.marshall(a0.getText(), a1)) + ",\"") + "constraintTypeProperty") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty.marshall(a0.getConstraintTypeProperty(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Text == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Text = Marshalling.getMarshaller(Text.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty == null) {
      org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty = Marshalling.getMarshaller(ConstraintTypeProperty.class);
    }
  }
}