package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;

public class Marshaller_o_k_w_c_d_a_d_m_InputClause_1_Impl implements GeneratedMarshaller<InputClause> {
  private InputClause[] EMPTY_ARRAY = new InputClause[0];
  private Marshaller<InputClauseLiteralExpression> org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpression = null;
  private Marshaller<InputClauseUnaryTests> org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTests = null;
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public InputClause[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public InputClause demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(InputClause.class, objId);
    }
    InputClause entity = new InputClause();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "inputExpression": entity.setInputExpression(org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpression.demarshall(objVal, a1));
        break;
        case "inputValues": entity.setInputValues(org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTests.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(InputClause a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.InputClause") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "inputExpression") + "\":") + org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpression.marshall(a0.getInputExpression(), a1)) + ",\"") + "inputValues") + "\":") + org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTests.marshall(a0.getInputValues(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpression == null) {
      org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpression = Marshalling.getMarshaller(InputClauseLiteralExpression.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTests == null) {
      org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTests = Marshalling.getMarshaller(InputClauseUnaryTests.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}