package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;

public class Marshaller_o_k_w_c_d_a_d_m_ItemDefinition_1_Impl implements GeneratedMarshaller<ItemDefinition> {
  private ItemDefinition[] EMPTY_ARRAY = new ItemDefinition[0];
  private Marshaller<QName> org_kie_workbench_common_dmn_api_property_dmn_QName = null;
  private Marshaller<UnaryTests> org_kie_workbench_common_dmn_api_definition_model_UnaryTests = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Name> org_kie_workbench_common_dmn_api_property_dmn_Name = null;
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ItemDefinition[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List ItemDefinition_List_itemComponent(ItemDefinition instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.ItemDefinition::itemComponent;
  }-*/;

  native static void ItemDefinition_List_itemComponent(ItemDefinition instance, List<ItemDefinition> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.ItemDefinition::itemComponent = value;
  }-*/;

  native static Boolean ItemDefinition_Boolean_allowOnlyVisualChange(ItemDefinition instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.ItemDefinition::allowOnlyVisualChange;
  }-*/;

  native static void ItemDefinition_Boolean_allowOnlyVisualChange(ItemDefinition instance, Boolean value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.ItemDefinition::allowOnlyVisualChange = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public ItemDefinition demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ItemDefinition.class, objId);
    }
    ItemDefinition entity = new ItemDefinition();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "typeRef": entity.setTypeRef(org_kie_workbench_common_dmn_api_property_dmn_QName.demarshall(objVal, a1));
        break;
        case "allowedValues": entity.setAllowedValues(org_kie_workbench_common_dmn_api_definition_model_UnaryTests.demarshall(objVal, a1));
        break;
        case "itemComponent": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.definition.model.ItemDefinition");
        ItemDefinition_List_itemComponent(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "typeLanguage": entity.setTypeLanguage(java_lang_String.demarshall(objVal, a1));
        break;
        case "isCollection": entity.setIsCollection(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "allowOnlyVisualChange": ItemDefinition_Boolean_allowOnlyVisualChange(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "name": entity.setName(org_kie_workbench_common_dmn_api_property_dmn_Name.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Boolean ItemDefinition_Boolean_isCollection(ItemDefinition instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.ItemDefinition::isCollection;
  }-*/;

  native static void ItemDefinition_Boolean_isCollection(ItemDefinition instance, Boolean value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.ItemDefinition::isCollection = value;
  }-*/;

  public String marshall(ItemDefinition a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.ItemDefinition") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "typeRef") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_QName.marshall(a0.getTypeRef(), a1)) + ",\"") + "allowedValues") + "\":") + org_kie_workbench_common_dmn_api_definition_model_UnaryTests.marshall(a0.getAllowedValues(), a1)) + ",\"") + "itemComponent") + "\":") + java_util_List.marshall(a0.getItemComponent(), a1)) + ",\"") + "typeLanguage") + "\":") + java_lang_String.marshall(a0.getTypeLanguage(), a1)) + ",\"") + "isCollection") + "\":") + java_lang_Boolean.marshall(ItemDefinition_Boolean_isCollection(a0), a1)) + ",\"") + "allowOnlyVisualChange") + "\":") + java_lang_Boolean.marshall(ItemDefinition_Boolean_allowOnlyVisualChange(a0), a1)) + ",\"") + "name") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Name.marshall(a0.getName(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_QName == null) {
      org_kie_workbench_common_dmn_api_property_dmn_QName = Marshalling.getMarshaller(QName.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_UnaryTests == null) {
      org_kie_workbench_common_dmn_api_definition_model_UnaryTests = Marshalling.getMarshaller(UnaryTests.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Name == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Name = Marshalling.getMarshaller(Name.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}