package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;

public class Marshaller_o_k_w_c_d_a_d_m_LiteralExpressionPMMLDocument_1_Impl implements GeneratedMarshaller<LiteralExpressionPMMLDocument> {
  private LiteralExpressionPMMLDocument[] EMPTY_ARRAY = new LiteralExpressionPMMLDocument[0];
  private Marshaller<Text> org_kie_workbench_common_dmn_api_property_dmn_Text = null;
  private Marshaller<ImportedValues> org_kie_workbench_common_dmn_api_definition_model_ImportedValues = null;
  private Marshaller<ExpressionLanguage> org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage = null;
  private Marshaller<QName> org_kie_workbench_common_dmn_api_property_dmn_QName = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public LiteralExpressionPMMLDocument[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List Expression_List_componentWidths(Expression instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.Expression::componentWidths;
  }-*/;

  native static void Expression_List_componentWidths(Expression instance, List<Double> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.Expression::componentWidths = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public LiteralExpressionPMMLDocument demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(LiteralExpressionPMMLDocument.class, objId);
    }
    LiteralExpressionPMMLDocument entity = new LiteralExpressionPMMLDocument();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "text": entity.setText(org_kie_workbench_common_dmn_api_property_dmn_Text.demarshall(objVal, a1));
        break;
        case "importedValues": entity.setImportedValues(org_kie_workbench_common_dmn_api_definition_model_ImportedValues.demarshall(objVal, a1));
        break;
        case "expressionLanguage": entity.setExpressionLanguage(org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage.demarshall(objVal, a1));
        break;
        case "typeRef": entity.setTypeRef(org_kie_workbench_common_dmn_api_property_dmn_QName.demarshall(objVal, a1));
        break;
        case "componentWidths": a1.setAssumedElementType("java.lang.Double");
        Expression_List_componentWidths(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(LiteralExpressionPMMLDocument a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "text") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Text.marshall(a0.getText(), a1)) + ",\"") + "importedValues") + "\":") + org_kie_workbench_common_dmn_api_definition_model_ImportedValues.marshall(a0.getImportedValues(), a1)) + ",\"") + "expressionLanguage") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage.marshall(a0.getExpressionLanguage(), a1)) + ",\"") + "typeRef") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_QName.marshall(a0.getTypeRef(), a1)) + ",\"") + "componentWidths") + "\":") + java_util_List.marshall(a0.getComponentWidths(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_Text == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Text = Marshalling.getMarshaller(Text.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_ImportedValues == null) {
      org_kie_workbench_common_dmn_api_definition_model_ImportedValues = Marshalling.getMarshaller(ImportedValues.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage == null) {
      org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage = Marshalling.getMarshaller(ExpressionLanguage.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_QName == null) {
      org_kie_workbench_common_dmn_api_property_dmn_QName = Marshalling.getMarshaller(QName.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}