package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;

public class Marshaller_o_k_w_c_d_a_d_m_OutputClauseLiteralExpression_1_Impl implements GeneratedMarshaller<OutputClauseLiteralExpression> {
  private OutputClauseLiteralExpression[] EMPTY_ARRAY = new OutputClauseLiteralExpression[0];
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<QName> org_kie_workbench_common_dmn_api_property_dmn_QName = null;
  private Marshaller<Text> org_kie_workbench_common_dmn_api_property_dmn_Text = null;
  private Marshaller<ImportedValues> org_kie_workbench_common_dmn_api_definition_model_ImportedValues = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public OutputClauseLiteralExpression[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Id OutputClauseLiteralExpression_Id_id(OutputClauseLiteralExpression instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression::id;
  }-*/;

  native static void OutputClauseLiteralExpression_Id_id(OutputClauseLiteralExpression instance, Id value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression::id = value;
  }-*/;

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public OutputClauseLiteralExpression demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(OutputClauseLiteralExpression.class, objId);
    }
    OutputClauseLiteralExpression entity = new OutputClauseLiteralExpression();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": OutputClauseLiteralExpression_Id_id(entity, org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "typeRef": entity.setTypeRef(org_kie_workbench_common_dmn_api_property_dmn_QName.demarshall(objVal, a1));
        break;
        case "text": entity.setText(org_kie_workbench_common_dmn_api_property_dmn_Text.demarshall(objVal, a1));
        break;
        case "importedValues": entity.setImportedValues(org_kie_workbench_common_dmn_api_definition_model_ImportedValues.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(OutputClauseLiteralExpression a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "typeRef") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_QName.marshall(a0.getTypeRef(), a1)) + ",\"") + "text") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Text.marshall(a0.getText(), a1)) + ",\"") + "importedValues") + "\":") + org_kie_workbench_common_dmn_api_definition_model_ImportedValues.marshall(a0.getImportedValues(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_QName == null) {
      org_kie_workbench_common_dmn_api_property_dmn_QName = Marshalling.getMarshaller(QName.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Text == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Text = Marshalling.getMarshaller(Text.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_ImportedValues == null) {
      org_kie_workbench_common_dmn_api_definition_model_ImportedValues = Marshalling.getMarshaller(ImportedValues.class);
    }
  }
}