package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.TextFormat;
import org.kie.workbench.common.dmn.api.property.font.FontSet;

public class Marshaller_o_k_w_c_d_a_d_m_TextAnnotation_1_Impl implements GeneratedMarshaller<TextAnnotation> {
  private TextAnnotation[] EMPTY_ARRAY = new TextAnnotation[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Text> org_kie_workbench_common_dmn_api_property_dmn_Text = null;
  private Marshaller<TextFormat> org_kie_workbench_common_dmn_api_property_dmn_TextFormat = null;
  private Marshaller<BackgroundSet> org_kie_workbench_common_dmn_api_property_background_BackgroundSet = null;
  private Marshaller<FontSet> org_kie_workbench_common_dmn_api_property_font_FontSet = null;
  private Marshaller<GeneralRectangleDimensionsSet> org_kie_workbench_common_dmn_api_property_dimensions_GeneralRectangleDimensionsSet = null;
  private Marshaller<Id> org_kie_workbench_common_dmn_api_property_dmn_Id = null;
  private Marshaller<Description> org_kie_workbench_common_dmn_api_property_dmn_Description = null;
  private Marshaller<ExtensionElements> org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public TextAnnotation[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext;
  }-*/;

  native static void DMNModelInstrumentedBase_Map_nsContext(DMNModelInstrumentedBase instance, Map<String, String> value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase::nsContext = value;
  }-*/;

  public TextAnnotation demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TextAnnotation.class, objId);
    }
    TextAnnotation entity = new TextAnnotation();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "allowOnlyVisualChange": entity.setAllowOnlyVisualChange(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "text": entity.setText(org_kie_workbench_common_dmn_api_property_dmn_Text.demarshall(objVal, a1));
        break;
        case "textFormat": entity.setTextFormat(org_kie_workbench_common_dmn_api_property_dmn_TextFormat.demarshall(objVal, a1));
        break;
        case "backgroundSet": entity.setBackgroundSet(org_kie_workbench_common_dmn_api_property_background_BackgroundSet.demarshall(objVal, a1));
        break;
        case "fontSet": entity.setFontSet(org_kie_workbench_common_dmn_api_property_font_FontSet.demarshall(objVal, a1));
        break;
        case "dimensionsSet": entity.setDimensionsSet(org_kie_workbench_common_dmn_api_property_dimensions_GeneralRectangleDimensionsSet.demarshall(objVal, a1));
        break;
        case "id": entity.setId(org_kie_workbench_common_dmn_api_property_dmn_Id.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(org_kie_workbench_common_dmn_api_property_dmn_Description.demarshall(objVal, a1));
        break;
        case "extensionElements": entity.setExtensionElements(org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.demarshall(objVal, a1));
        break;
        case "nsContext": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        DMNModelInstrumentedBase_Map_nsContext(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "additionalAttributes": a1.setAssumedMapKeyType("org.kie.workbench.common.dmn.api.property.dmn.QName");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setAdditionalAttributes(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "parent": entity.setParent((DMNModelInstrumentedBase) ((ObjectMarshaller) java_lang_Object).demarshall(DMNModelInstrumentedBase.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean TextAnnotation_boolean_allowOnlyVisualChange(TextAnnotation instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.definition.model.TextAnnotation::allowOnlyVisualChange;
  }-*/;

  native static void TextAnnotation_boolean_allowOnlyVisualChange(TextAnnotation instance, boolean value) /*-{
    instance.@org.kie.workbench.common.dmn.api.definition.model.TextAnnotation::allowOnlyVisualChange = value;
  }-*/;

  public String marshall(TextAnnotation a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.definition.model.TextAnnotation") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "allowOnlyVisualChange") + "\":") + java_lang_Boolean.marshall(TextAnnotation_boolean_allowOnlyVisualChange(a0), a1)) + ",\"") + "text") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Text.marshall(a0.getText(), a1)) + ",\"") + "textFormat") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_TextFormat.marshall(a0.getTextFormat(), a1)) + ",\"") + "backgroundSet") + "\":") + org_kie_workbench_common_dmn_api_property_background_BackgroundSet.marshall(a0.getBackgroundSet(), a1)) + ",\"") + "fontSet") + "\":") + org_kie_workbench_common_dmn_api_property_font_FontSet.marshall(a0.getFontSet(), a1)) + ",\"") + "dimensionsSet") + "\":") + org_kie_workbench_common_dmn_api_property_dimensions_GeneralRectangleDimensionsSet.marshall(a0.getDimensionsSet(), a1)) + ",\"") + "id") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Id.marshall(a0.getId(), a1)) + ",\"") + "description") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_Description.marshall(a0.getDescription(), a1)) + ",\"") + "extensionElements") + "\":") + org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements.marshall(a0.getExtensionElements(), a1)) + ",\"") + "nsContext") + "\":") + java_util_Map.marshall(a0.getNsContext(), a1)) + ",\"") + "additionalAttributes") + "\":") + java_util_Map.marshall(a0.getAdditionalAttributes(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_Text == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Text = Marshalling.getMarshaller(Text.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_TextFormat == null) {
      org_kie_workbench_common_dmn_api_property_dmn_TextFormat = Marshalling.getMarshaller(TextFormat.class);
    }
    if (org_kie_workbench_common_dmn_api_property_background_BackgroundSet == null) {
      org_kie_workbench_common_dmn_api_property_background_BackgroundSet = Marshalling.getMarshaller(BackgroundSet.class);
    }
    if (org_kie_workbench_common_dmn_api_property_font_FontSet == null) {
      org_kie_workbench_common_dmn_api_property_font_FontSet = Marshalling.getMarshaller(FontSet.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dimensions_GeneralRectangleDimensionsSet == null) {
      org_kie_workbench_common_dmn_api_property_dimensions_GeneralRectangleDimensionsSet = Marshalling.getMarshaller(GeneralRectangleDimensionsSet.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Id == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Id = Marshalling.getMarshaller(Id.class);
    }
    if (org_kie_workbench_common_dmn_api_property_dmn_Description == null) {
      org_kie_workbench_common_dmn_api_property_dmn_Description = Marshalling.getMarshaller(Description.class);
    }
    if (org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements == null) {
      org_kie_workbench_common_dmn_api_definition_model_DMNElement_erraiD_ExtensionElements = Marshalling.getMarshaller(ExtensionElements.class);
    }
  }
}