package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;

public class Marshaller_o_k_w_c_d_a_e_i_DMNIncludedModel_1_Impl implements GeneratedMarshaller<DMNIncludedModel> {
  private DMNIncludedModel[] EMPTY_ARRAY = new DMNIncludedModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public DMNIncludedModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String BaseIncludedModel_String_modelName(BaseIncludedModel instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::modelName;
  }-*/;

  native static void BaseIncludedModel_String_modelName(BaseIncludedModel instance, String value) /*-{
    instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::modelName = value;
  }-*/;

  native static String BaseIncludedModel_String_modelPackage(BaseIncludedModel instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::modelPackage;
  }-*/;

  native static void BaseIncludedModel_String_modelPackage(BaseIncludedModel instance, String value) /*-{
    instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::modelPackage = value;
  }-*/;

  native static String BaseIncludedModel_String_path(BaseIncludedModel instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::path;
  }-*/;

  native static void BaseIncludedModel_String_path(BaseIncludedModel instance, String value) /*-{
    instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::path = value;
  }-*/;

  native static String BaseIncludedModel_String_importType(BaseIncludedModel instance) /*-{
    return instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::importType;
  }-*/;

  native static void BaseIncludedModel_String_importType(BaseIncludedModel instance, String value) /*-{
    instance.@org.kie.workbench.common.dmn.api.editors.included.BaseIncludedModel::importType = value;
  }-*/;

  public DMNIncludedModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DMNIncludedModel.class, objId);
    }
    final String c3 = java_lang_String.demarshall(obj.get("namespace"), a1);
    final Integer c5 = java_lang_Integer.demarshall(obj.get("drgElementsCount"), a1);
    final Integer c6 = java_lang_Integer.demarshall(obj.get("itemDefinitionsCount"), a1);
    final String c0 = java_lang_String.demarshall(obj.get("modelName"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("modelPackage"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("path"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("importType"), a1);
    DMNIncludedModel entity = new DMNIncludedModel(c0, c1, c2, c3, c4, c5, c6);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "modelName": BaseIncludedModel_String_modelName(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "modelPackage": BaseIncludedModel_String_modelPackage(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "path": BaseIncludedModel_String_path(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "importType": BaseIncludedModel_String_importType(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DMNIncludedModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "namespace") + "\":") + java_lang_String.marshall(a0.getNamespace(), a1)) + ",\"") + "drgElementsCount") + "\":") + java_lang_Integer.marshall(a0.getDrgElementsCount(), a1)) + ",\"") + "itemDefinitionsCount") + "\":") + java_lang_Integer.marshall(a0.getItemDefinitionsCount(), a1)) + ",\"") + "modelName") + "\":") + java_lang_String.marshall(a0.getModelName(), a1)) + ",\"") + "modelPackage") + "\":") + java_lang_String.marshall(a0.getModelPackage(), a1)) + ",\"") + "path") + "\":") + java_lang_String.marshall(a0.getPath(), a1)) + ",\"") + "importType") + "\":") + java_lang_String.marshall(a0.getImportType(), a1)) + "}");
  }

  private void lazyInit() {

  }
}