package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;

public class Marshaller_o_k_w_c_d_a_e_i_DMNIncludedNode_1_Impl implements GeneratedMarshaller<DMNIncludedNode> {
  private DMNIncludedNode[] EMPTY_ARRAY = new DMNIncludedNode[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public DMNIncludedNode[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DMNIncludedNode demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DMNIncludedNode.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("fileName"), a1);
    final DRGElement c1 = (DRGElement) ((ObjectMarshaller) java_lang_Object).demarshall(DRGElement.class, obj.get("drgElement"), a1);
    DMNIncludedNode entity = new DMNIncludedNode(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(DMNIncludedNode a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "fileName") + "\":") + java_lang_String.marshall(a0.getFileName(), a1)) + ",\"") + "drgElement") + "\":") + java_lang_Object.marshall(a0.getDrgElement(), a1)) + "}");
  }

  private void lazyInit() {

  }
}