package org.jboss.errai.marshalling.client.api;

import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;

public class Marshaller_o_k_w_c_d_a_e_i_PMMLDocumentMetadata_1_Impl implements GeneratedMarshaller<PMMLDocumentMetadata> {
  private PMMLDocumentMetadata[] EMPTY_ARRAY = new PMMLDocumentMetadata[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public PMMLDocumentMetadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PMMLDocumentMetadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PMMLDocumentMetadata.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("path"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("name"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("importType"), a1);
    a1.setAssumedElementType("org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata");
    final List c3 = java_util_List.demarshall(obj.get("models"), a1);
    PMMLDocumentMetadata entity = new PMMLDocumentMetadata(c0, c1, c2, c3);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(PMMLDocumentMetadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "path") + "\":") + java_lang_String.marshall(a0.getPath(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "importType") + "\":") + java_lang_String.marshall(a0.getImportType(), a1)) + ",\"") + "models") + "\":") + java_util_List.marshall(a0.getModels(), a1)) + "}");
  }

  private void lazyInit() {

  }
}