package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;

public class Marshaller_o_k_w_c_d_a_e_i_PMMLModelMetadata_1_Impl implements GeneratedMarshaller<PMMLModelMetadata> {
  private PMMLModelMetadata[] EMPTY_ARRAY = new PMMLModelMetadata[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public PMMLModelMetadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PMMLModelMetadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PMMLModelMetadata.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    a1.setAssumedElementType("org.kie.workbench.common.dmn.api.editors.included.PMMLParameterMetadata");
    final Set c1 = java_util_Set.demarshall(obj.get("inputParameters"), a1);
    PMMLModelMetadata entity = new PMMLModelMetadata(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(PMMLModelMetadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "inputParameters") + "\":") + java_util_Set.marshall(a0.getInputParameters(), a1)) + "}");
  }

  private void lazyInit() {

  }
}