package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;

public class Marshaller_o_k_w_c_d_a_e_t_DMNSimpleTimeZone_1_Impl implements GeneratedMarshaller<DMNSimpleTimeZone> {
  private DMNSimpleTimeZone[] EMPTY_ARRAY = new DMNSimpleTimeZone[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  public DMNSimpleTimeZone[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DMNSimpleTimeZone demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DMNSimpleTimeZone.class, objId);
    }
    DMNSimpleTimeZone entity = new DMNSimpleTimeZone();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": entity.setId(java_lang_String.demarshall(objVal, a1));
        break;
        case "offset": entity.setOffset(java_lang_Double.demarshall(objVal, a1));
        break;
        case "offsetString": entity.setOffsetString(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DMNSimpleTimeZone a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "offset") + "\":") + java_lang_Double.marshall(a0.getOffset(), a1)) + ",\"") + "offsetString") + "\":") + java_lang_String.marshall(a0.getOffsetString(), a1)) + "}");
  }

  private void lazyInit() {

  }
}