package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;

public class Marshaller_o_k_w_c_d_a_e_t_RangeValue_1_Impl implements GeneratedMarshaller<RangeValue> {
  private RangeValue[] EMPTY_ARRAY = new RangeValue[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public RangeValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RangeValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RangeValue.class, objId);
    }
    RangeValue entity = new RangeValue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "includeStartValue": entity.setIncludeStartValue(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "startValue": entity.setStartValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "endValue": entity.setEndValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "includeEndValue": entity.setIncludeEndValue(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RangeValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.editors.types.RangeValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "includeStartValue") + "\":") + java_lang_Boolean.marshall(a0.getIncludeStartValue(), a1)) + ",\"") + "startValue") + "\":") + java_lang_String.marshall(a0.getStartValue(), a1)) + ",\"") + "endValue") + "\":") + java_lang_String.marshall(a0.getEndValue(), a1)) + ",\"") + "includeEndValue") + "\":") + java_lang_Boolean.marshall(a0.getIncludeEndValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}