package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.background.BgColour;
import org.kie.workbench.common.dmn.api.property.background.BorderColour;
import org.kie.workbench.common.dmn.api.property.background.BorderSize;

public class Marshaller_o_k_w_c_d_a_p_b_BackgroundSet_1_Impl implements GeneratedMarshaller<BackgroundSet> {
  private BackgroundSet[] EMPTY_ARRAY = new BackgroundSet[0];
  private Marshaller<BgColour> org_kie_workbench_common_dmn_api_property_background_BgColour = null;
  private Marshaller<BorderColour> org_kie_workbench_common_dmn_api_property_background_BorderColour = null;
  private Marshaller<BorderSize> org_kie_workbench_common_dmn_api_property_background_BorderSize = null;
  public BackgroundSet[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public BackgroundSet demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(BackgroundSet.class, objId);
    }
    BackgroundSet entity = new BackgroundSet();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "bgColour": entity.setBgColour(org_kie_workbench_common_dmn_api_property_background_BgColour.demarshall(objVal, a1));
        break;
        case "borderColour": entity.setBorderColour(org_kie_workbench_common_dmn_api_property_background_BorderColour.demarshall(objVal, a1));
        break;
        case "borderSize": entity.setBorderSize(org_kie_workbench_common_dmn_api_property_background_BorderSize.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(BackgroundSet a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.property.background.BackgroundSet") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "bgColour") + "\":") + org_kie_workbench_common_dmn_api_property_background_BgColour.marshall(a0.getBgColour(), a1)) + ",\"") + "borderColour") + "\":") + org_kie_workbench_common_dmn_api_property_background_BorderColour.marshall(a0.getBorderColour(), a1)) + ",\"") + "borderSize") + "\":") + org_kie_workbench_common_dmn_api_property_background_BorderSize.marshall(a0.getBorderSize(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_background_BgColour == null) {
      org_kie_workbench_common_dmn_api_property_background_BgColour = Marshalling.getMarshaller(BgColour.class);
    }
    if (org_kie_workbench_common_dmn_api_property_background_BorderColour == null) {
      org_kie_workbench_common_dmn_api_property_background_BorderColour = Marshalling.getMarshaller(BorderColour.class);
    }
    if (org_kie_workbench_common_dmn_api_property_background_BorderSize == null) {
      org_kie_workbench_common_dmn_api_property_background_BorderSize = Marshalling.getMarshaller(BorderSize.class);
    }
  }
}