package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;

public class Marshaller_o_k_w_c_d_a_p_d_DMNExternalLink_1_Impl implements GeneratedMarshaller<DMNExternalLink> {
  private DMNExternalLink[] EMPTY_ARRAY = new DMNExternalLink[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DMNExternalLink[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DMNExternalLink demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DMNExternalLink.class, objId);
    }
    DMNExternalLink entity = new DMNExternalLink();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "url": entity.setUrl(java_lang_String.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DMNExternalLink a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "url") + "\":") + java_lang_String.marshall(a0.getUrl(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + "}");
  }

  private void lazyInit() {

  }
}