package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;

public class Marshaller_o_k_w_c_d_a_p_d_DocumentationLinks_1_Impl implements GeneratedMarshaller<DocumentationLinks> {
  private DocumentationLinks[] EMPTY_ARRAY = new DocumentationLinks[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public DocumentationLinks[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DocumentationLinks demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DocumentationLinks.class, objId);
    }
    DocumentationLinks entity = new DocumentationLinks();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "links": a1.setAssumedElementType("org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink");
        entity.setLinks(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DocumentationLinks a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "links") + "\":") + java_util_List.marshall(a0.getLinks(), a1)) + "}");
  }

  private void lazyInit() {

  }
}