package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.property.dimensions.Height;

public class Marshaller_o_k_w_c_d_a_p_d_Height_1_Impl implements GeneratedMarshaller<Height> {
  private Height[] EMPTY_ARRAY = new Height[0];
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  public Height[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Height demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Height.class, objId);
    }
    Height entity = new Height();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_lang_Double.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Height a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.property.dimensions.Height") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_lang_Double.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}