package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.QNameHolder;

public class Marshaller_o_k_w_c_d_a_p_d_QNameHolder_1_Impl implements GeneratedMarshaller<QNameHolder> {
  private QNameHolder[] EMPTY_ARRAY = new QNameHolder[0];
  private Marshaller<QName> org_kie_workbench_common_dmn_api_property_dmn_QName = null;
  public QNameHolder[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public QNameHolder demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(QNameHolder.class, objId);
    }
    QNameHolder entity = new QNameHolder();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(org_kie_workbench_common_dmn_api_property_dmn_QName.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(QNameHolder a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.property.dmn.QNameHolder") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + org_kie_workbench_common_dmn_api_property_dmn_QName.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_dmn_QName == null) {
      org_kie_workbench_common_dmn_api_property_dmn_QName = Marshalling.getMarshaller(QName.class);
    }
  }
}