package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.dmn.api.property.font.FontColour;
import org.kie.workbench.common.dmn.api.property.font.FontFamily;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.api.property.font.FontSize;

public class Marshaller_o_k_w_c_d_a_p_f_FontSet_1_Impl implements GeneratedMarshaller<FontSet> {
  private FontSet[] EMPTY_ARRAY = new FontSet[0];
  private Marshaller<FontFamily> org_kie_workbench_common_dmn_api_property_font_FontFamily = null;
  private Marshaller<FontColour> org_kie_workbench_common_dmn_api_property_font_FontColour = null;
  private Marshaller<FontSize> org_kie_workbench_common_dmn_api_property_font_FontSize = null;
  public FontSet[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public FontSet demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FontSet.class, objId);
    }
    FontSet entity = new FontSet();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "fontFamily": entity.setFontFamily(org_kie_workbench_common_dmn_api_property_font_FontFamily.demarshall(objVal, a1));
        break;
        case "fontColour": entity.setFontColour(org_kie_workbench_common_dmn_api_property_font_FontColour.demarshall(objVal, a1));
        break;
        case "fontSize": entity.setFontSize(org_kie_workbench_common_dmn_api_property_font_FontSize.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FontSet a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.dmn.api.property.font.FontSet") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "fontFamily") + "\":") + org_kie_workbench_common_dmn_api_property_font_FontFamily.marshall(a0.getFontFamily(), a1)) + ",\"") + "fontColour") + "\":") + org_kie_workbench_common_dmn_api_property_font_FontColour.marshall(a0.getFontColour(), a1)) + ",\"") + "fontSize") + "\":") + org_kie_workbench_common_dmn_api_property_font_FontSize.marshall(a0.getFontSize(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_dmn_api_property_font_FontFamily == null) {
      org_kie_workbench_common_dmn_api_property_font_FontFamily = Marshalling.getMarshaller(FontFamily.class);
    }
    if (org_kie_workbench_common_dmn_api_property_font_FontColour == null) {
      org_kie_workbench_common_dmn_api_property_font_FontColour = Marshalling.getMarshaller(FontColour.class);
    }
    if (org_kie_workbench_common_dmn_api_property_font_FontSize == null) {
      org_kie_workbench_common_dmn_api_property_font_FontSize = Marshalling.getMarshaller(FontSize.class);
    }
  }
}