package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.data.modeller.model.Source;

public class Marshaller_o_k_w_c_f_d_m_m_DataObjectFormModel_1_Impl implements GeneratedMarshaller<DataObjectFormModel> {
  private DataObjectFormModel[] EMPTY_ARRAY = new DataObjectFormModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Source> org_kie_workbench_common_forms_data_modeller_model_Source = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public DataObjectFormModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DataObjectFormModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataObjectFormModel.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("className"), a1);
    DataObjectFormModel entity = new DataObjectFormModel(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "source": entity.setSource(objVal.isObject() != null ? Enum.valueOf(Source.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Source.class, objVal.isString().stringValue()) : null);
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "properties": a1.setAssumedElementType("org.kie.workbench.common.forms.model.ModelProperty");
        entity.setProperties(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DataObjectFormModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "source") + "\":") + (a0.getSource() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.data.modeller.model.Source") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getSource().name()) + "\"}" : "null")) + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "properties") + "\":") + java_util_List.marshall(a0.getProperties(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_forms_data_modeller_model_Source == null) {
      org_kie_workbench_common_forms_data_modeller_model_Source = Marshalling.getMarshaller(Source.class);
    }
  }
}