package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.validation.DynamicModelConstraints;

public class Marshaller_o_k_w_c_f_d_s_s_i_v_DynamicModelConstraints_1_Impl implements GeneratedMarshaller<DynamicModelConstraints> {
  private DynamicModelConstraints[] EMPTY_ARRAY = new DynamicModelConstraints[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public DynamicModelConstraints[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DynamicModelConstraints demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DynamicModelConstraints.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("modelType"), a1);
    DynamicModelConstraints entity = new DynamicModelConstraints(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "fieldConstraints": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.util.List");
        entity.setFieldConstraints(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(DynamicModelConstraints a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.dynamic.service.shared.impl.validation.DynamicModelConstraints") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "modelType") + "\":") + java_lang_String.marshall(a0.getModelType(), a1)) + ",\"") + "fieldConstraints") + "\":") + java_util_Map.marshall(a0.getFieldConstraints(), a1)) + "}");
  }

  private void lazyInit() {

  }
}