package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.IntegerMultipleInputFieldDefinition;

public class Marshaller_o_k_w_c_f_f_s_f_b_l_i_i_IntegerMultipleInputFieldDefinition_1_Impl implements GeneratedMarshaller<IntegerMultipleInputFieldDefinition> {
  private IntegerMultipleInputFieldDefinition[] EMPTY_ARRAY = new IntegerMultipleInputFieldDefinition[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public IntegerMultipleInputFieldDefinition[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public IntegerMultipleInputFieldDefinition demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(IntegerMultipleInputFieldDefinition.class, objId);
    }
    IntegerMultipleInputFieldDefinition entity = new IntegerMultipleInputFieldDefinition();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "pageSize": entity.setPageSize(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "label": entity.setLabel(java_lang_String.demarshall(objVal, a1));
        break;
        case "required": entity.setRequired(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "readOnly": entity.setReadOnly(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "validateOnChange": entity.setValidateOnChange(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "helpMessage": entity.setHelpMessage(java_lang_String.demarshall(objVal, a1));
        break;
        case "binding": entity.setBinding(java_lang_String.demarshall(objVal, a1));
        break;
        case "standaloneClassName": entity.setStandaloneClassName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(IntegerMultipleInputFieldDefinition a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.IntegerMultipleInputFieldDefinition") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "pageSize") + "\":") + java_lang_Integer.marshall(a0.getPageSize(), a1)) + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "label") + "\":") + java_lang_String.marshall(a0.getLabel(), a1)) + ",\"") + "required") + "\":") + java_lang_Boolean.marshall(a0.getRequired(), a1)) + ",\"") + "readOnly") + "\":") + java_lang_Boolean.marshall(a0.getReadOnly(), a1)) + ",\"") + "validateOnChange") + "\":") + java_lang_Boolean.marshall(a0.getValidateOnChange(), a1)) + ",\"") + "helpMessage") + "\":") + java_lang_String.marshall(a0.getHelpMessage(), a1)) + ",\"") + "binding") + "\":") + java_lang_String.marshall(a0.getBinding(), a1)) + ",\"") + "standaloneClassName") + "\":") + java_lang_String.marshall(a0.getStandaloneClassName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}