package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.StringMultipleSelectorFieldDefinition;

public class Marshaller_o_k_w_c_f_f_s_f_b_l_s_i_StringMultipleSelectorFieldDefinition_1_Impl implements GeneratedMarshaller<StringMultipleSelectorFieldDefinition> {
  private StringMultipleSelectorFieldDefinition[] EMPTY_ARRAY = new StringMultipleSelectorFieldDefinition[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public StringMultipleSelectorFieldDefinition[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public StringMultipleSelectorFieldDefinition demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(StringMultipleSelectorFieldDefinition.class, objId);
    }
    StringMultipleSelectorFieldDefinition entity = new StringMultipleSelectorFieldDefinition();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "listOfValues": a1.setAssumedElementType("java.lang.String");
        entity.setListOfValues(java_util_List.demarshall(objVal, a1));
        break;
        case "maxDropdownElements": entity.setMaxDropdownElements(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "maxElementsOnTitle": entity.setMaxElementsOnTitle(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "allowFilter": entity.setAllowFilter(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "allowClearSelection": entity.setAllowClearSelection(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "id": entity.setId(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "label": entity.setLabel(java_lang_String.demarshall(objVal, a1));
        break;
        case "required": entity.setRequired(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "readOnly": entity.setReadOnly(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "validateOnChange": entity.setValidateOnChange(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "helpMessage": entity.setHelpMessage(java_lang_String.demarshall(objVal, a1));
        break;
        case "binding": entity.setBinding(java_lang_String.demarshall(objVal, a1));
        break;
        case "standaloneClassName": entity.setStandaloneClassName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(StringMultipleSelectorFieldDefinition a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.StringMultipleSelectorFieldDefinition") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "listOfValues") + "\":") + java_util_List.marshall(a0.getListOfValues(), a1)) + ",\"") + "maxDropdownElements") + "\":") + java_lang_Integer.marshall(a0.getMaxDropdownElements(), a1)) + ",\"") + "maxElementsOnTitle") + "\":") + java_lang_Integer.marshall(a0.getMaxElementsOnTitle(), a1)) + ",\"") + "allowFilter") + "\":") + java_lang_Boolean.marshall(a0.getAllowFilter(), a1)) + ",\"") + "allowClearSelection") + "\":") + java_lang_Boolean.marshall(a0.getAllowClearSelection(), a1)) + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "label") + "\":") + java_lang_String.marshall(a0.getLabel(), a1)) + ",\"") + "required") + "\":") + java_lang_Boolean.marshall(a0.getRequired(), a1)) + ",\"") + "readOnly") + "\":") + java_lang_Boolean.marshall(a0.getReadOnly(), a1)) + ",\"") + "validateOnChange") + "\":") + java_lang_Boolean.marshall(a0.getValidateOnChange(), a1)) + ",\"") + "helpMessage") + "\":") + java_lang_String.marshall(a0.getHelpMessage(), a1)) + ",\"") + "binding") + "\":") + java_lang_String.marshall(a0.getBinding(), a1)) + ",\"") + "standaloneClassName") + "\":") + java_lang_String.marshall(a0.getStandaloneClassName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}