package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel;

public class Marshaller_o_k_w_c_f_j_m_a_t_TaskFormModel_1_Impl implements GeneratedMarshaller<TaskFormModel> {
  private TaskFormModel[] EMPTY_ARRAY = new TaskFormModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public TaskFormModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public TaskFormModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TaskFormModel.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("processId"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("taskName"), a1);
    a1.setAssumedElementType("org.kie.workbench.common.forms.model.ModelProperty");
    final List c2 = java_util_List.demarshall(obj.get("properties"), a1);
    TaskFormModel entity = new TaskFormModel(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "processId": entity.setProcessId(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "properties": a1.setAssumedElementType("org.kie.workbench.common.forms.model.ModelProperty");
        entity.setProperties(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(TaskFormModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.jbpm.model.authoring.task.TaskFormModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "taskName") + "\":") + java_lang_String.marshall(a0.getTaskName(), a1)) + ",\"") + "processId") + "\":") + java_lang_String.marshall(a0.getProcessId(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "properties") + "\":") + java_util_List.marshall(a0.getProperties(), a1)) + "}");
  }

  private void lazyInit() {

  }
}