package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentData;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentStatus;

public class Marshaller_o_k_w_c_f_j_m_d_DocumentData_1_Impl implements GeneratedMarshaller<DocumentData> {
  private DocumentData[] EMPTY_ARRAY = new DocumentData[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<DocumentStatus> org_kie_workbench_common_forms_jbpm_model_document_DocumentStatus = null;
  public DocumentData[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DocumentData demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DocumentData.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("fileName"), a1);
    final Long c1 = java_lang_Long.demarshall(obj.get("size"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("link"), a1);
    DocumentData entity = new DocumentData(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "contentId": entity.setContentId(java_lang_String.demarshall(objVal, a1));
        break;
        case "lastModified": entity.setLastModified(java_lang_Long.demarshall(objVal, a1));
        break;
        case "status": entity.setStatus(objVal.isObject() != null ? Enum.valueOf(DocumentStatus.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(DocumentStatus.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(DocumentData a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.jbpm.model.document.DocumentData") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "contentId") + "\":") + java_lang_String.marshall(a0.getContentId(), a1)) + ",\"") + "fileName") + "\":") + java_lang_String.marshall(a0.getFileName(), a1)) + ",\"") + "size") + "\":") + java_lang_Long.marshall(a0.getSize(), a1)) + ",\"") + "link") + "\":") + java_lang_String.marshall(a0.getLink(), a1)) + ",\"") + "lastModified") + "\":") + java_lang_Long.marshall(a0.getLastModified(), a1)) + ",\"") + "status") + "\":") + (a0.getStatus() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.jbpm.model.document.DocumentStatus") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getStatus().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_forms_jbpm_model_document_DocumentStatus == null) {
      org_kie_workbench_common_forms_jbpm_model_document_DocumentStatus = Marshalling.getMarshaller(DocumentStatus.class);
    }
  }
}