package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.forms.model.ModelMetaData;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.impl.ModelPropertyImpl;

public class Marshaller_o_k_w_c_f_m_i_ModelPropertyImpl_1_Impl implements GeneratedMarshaller<ModelPropertyImpl> {
  private ModelPropertyImpl[] EMPTY_ARRAY = new ModelPropertyImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ModelPropertyImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static ModelMetaData ModelPropertyImpl_ModelMetaData_metaData(ModelPropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.forms.model.impl.ModelPropertyImpl::metaData;
  }-*/;

  native static void ModelPropertyImpl_ModelMetaData_metaData(ModelPropertyImpl instance, ModelMetaData value) /*-{
    instance.@org.kie.workbench.common.forms.model.impl.ModelPropertyImpl::metaData = value;
  }-*/;

  public ModelPropertyImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ModelPropertyImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final TypeInfo c1 = (TypeInfo) ((ObjectMarshaller) java_lang_Object).demarshall(TypeInfo.class, obj.get("typeInfo"), a1);
    ModelPropertyImpl entity = new ModelPropertyImpl(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "metaData": ModelPropertyImpl_ModelMetaData_metaData(entity, (ModelMetaData) ((ObjectMarshaller) java_lang_Object).demarshall(ModelMetaData.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ModelPropertyImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.model.impl.ModelPropertyImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "typeInfo") + "\":") + java_lang_Object.marshall(a0.getTypeInfo(), a1)) + ",\"") + "metaData") + "\":") + java_lang_Object.marshall(a0.getMetaData(), a1)) + "}");
  }

  private void lazyInit() {

  }
}