package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.model.impl.PortableJavaModel;

public class Marshaller_o_k_w_c_f_m_i_PortableJavaModel_1_Impl implements GeneratedMarshaller<PortableJavaModel> {
  private PortableJavaModel[] EMPTY_ARRAY = new PortableJavaModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public PortableJavaModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PortableJavaModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PortableJavaModel.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("type"), a1);
    PortableJavaModel entity = new PortableJavaModel(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "properties": a1.setAssumedElementType("org.kie.workbench.common.forms.model.ModelProperty");
        entity.setProperties(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(PortableJavaModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.model.impl.PortableJavaModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "properties") + "\":") + java_util_List.marshall(a0.getProperties(), a1)) + "}");
  }

  private void lazyInit() {

  }
}