package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.forms.model.impl.meta.entries.AbstractMetaDataEntry;
import org.kie.workbench.common.forms.model.impl.meta.entries.FieldTypeEntry;

public class Marshaller_o_k_w_c_f_m_i_m_e_FieldTypeEntry_1_Impl implements GeneratedMarshaller<FieldTypeEntry> {
  private FieldTypeEntry[] EMPTY_ARRAY = new FieldTypeEntry[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public FieldTypeEntry[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractMetaDataEntry_String_name(AbstractMetaDataEntry instance) /*-{
    return instance.@org.kie.workbench.common.forms.model.impl.meta.entries.AbstractMetaDataEntry::name;
  }-*/;

  native static void AbstractMetaDataEntry_String_name(AbstractMetaDataEntry instance, String value) /*-{
    instance.@org.kie.workbench.common.forms.model.impl.meta.entries.AbstractMetaDataEntry::name = value;
  }-*/;

  native static String AbstractMetaDataEntry_String_value(AbstractMetaDataEntry instance) /*-{
    return instance.@org.kie.workbench.common.forms.model.impl.meta.entries.AbstractMetaDataEntry::value;
  }-*/;

  native static void AbstractMetaDataEntry_String_value(AbstractMetaDataEntry instance, String value) /*-{
    instance.@org.kie.workbench.common.forms.model.impl.meta.entries.AbstractMetaDataEntry::value = value;
  }-*/;

  public FieldTypeEntry demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FieldTypeEntry.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("value"), a1);
    FieldTypeEntry entity = new FieldTypeEntry(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": AbstractMetaDataEntry_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "value": AbstractMetaDataEntry_String_value(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FieldTypeEntry a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.forms.model.impl.meta.entries.FieldTypeEntry") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}