package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.bpmn.definition.BaseConnector;
import org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.connectors.SequenceFlowExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;

public class Marshaller_o_k_w_c_s_b_d_SequenceFlow_1_Impl implements GeneratedMarshaller<SequenceFlow> {
  private SequenceFlow[] EMPTY_ARRAY = new SequenceFlow[0];
  private Marshaller<BPMNGeneralSet> org_kie_workbench_common_stunner_bpmn_definition_property_general_BPMNGeneralSet = null;
  private Marshaller<SequenceFlowExecutionSet> org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSet = null;
  private Marshaller<BackgroundSet> org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSet = null;
  private Marshaller<FontSet> org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSet = null;
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public SequenceFlow[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Set BaseConnector_Set_labels(BaseConnector instance) /*-{
    return instance.@org.kie.workbench.common.stunner.bpmn.definition.BaseConnector::labels;
  }-*/;

  native static void BaseConnector_Set_labels(BaseConnector instance, Set<String> value) /*-{
    instance.@org.kie.workbench.common.stunner.bpmn.definition.BaseConnector::labels = value;
  }-*/;

  public SequenceFlow demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SequenceFlow.class, objId);
    }
    final BPMNGeneralSet c0 = org_kie_workbench_common_stunner_bpmn_definition_property_general_BPMNGeneralSet.demarshall(obj.get("general"), a1);
    final SequenceFlowExecutionSet c1 = org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSet.demarshall(obj.get("executionSet"), a1);
    final BackgroundSet c2 = org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSet.demarshall(obj.get("backgroundSet"), a1);
    final FontSet c3 = org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSet.demarshall(obj.get("fontSet"), a1);
    SequenceFlow entity = new SequenceFlow(c0, c1, c2, c3);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "general": entity.setGeneral(org_kie_workbench_common_stunner_bpmn_definition_property_general_BPMNGeneralSet.demarshall(objVal, a1));
        break;
        case "backgroundSet": entity.setBackgroundSet(org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSet.demarshall(objVal, a1));
        break;
        case "fontSet": entity.setFontSet(org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSet.demarshall(objVal, a1));
        break;
        case "labels": a1.setAssumedElementType("java.lang.String");
        BaseConnector_Set_labels(entity, java_util_Set.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(SequenceFlow a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "executionSet") + "\":") + org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSet.marshall(a0.getExecutionSet(), a1)) + ",\"") + "general") + "\":") + org_kie_workbench_common_stunner_bpmn_definition_property_general_BPMNGeneralSet.marshall(a0.getGeneral(), a1)) + ",\"") + "backgroundSet") + "\":") + org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSet.marshall(a0.getBackgroundSet(), a1)) + ",\"") + "fontSet") + "\":") + org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSet.marshall(a0.getFontSet(), a1)) + ",\"") + "labels") + "\":") + java_util_Set.marshall(a0.getLabels(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_stunner_bpmn_definition_property_general_BPMNGeneralSet == null) {
      org_kie_workbench_common_stunner_bpmn_definition_property_general_BPMNGeneralSet = Marshalling.getMarshaller(BPMNGeneralSet.class);
    }
    if (org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSet == null) {
      org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSet = Marshalling.getMarshaller(SequenceFlowExecutionSet.class);
    }
    if (org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSet == null) {
      org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSet = Marshalling.getMarshaller(BackgroundSet.class);
    }
    if (org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSet == null) {
      org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSet = Marshalling.getMarshaller(FontSet.class);
    }
  }
}