package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;

public class Marshaller_o_k_w_c_s_b_d_p_c_CaseRoles_1_Impl implements GeneratedMarshaller<CaseRoles> {
  private CaseRoles[] EMPTY_ARRAY = new CaseRoles[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public CaseRoles[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public CaseRoles demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(CaseRoles.class, objId);
    }
    CaseRoles entity = new CaseRoles();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(CaseRoles a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}