package org.jboss.errai.marshalling.client.api;

import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.ImportsValue;

public class Marshaller_o_k_w_c_s_b_d_p_d_i_ImportsValue_1_Impl implements GeneratedMarshaller<ImportsValue> {
  private ImportsValue[] EMPTY_ARRAY = new ImportsValue[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public ImportsValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ImportsValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ImportsValue.class, objId);
    }
    a1.setAssumedElementType("org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.DefaultImport");
    final List c0 = java_util_List.demarshall(obj.get("defaultImports"), a1);
    a1.setAssumedElementType("org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.WSDLImport");
    final List c1 = java_util_List.demarshall(obj.get("wsdlImports"), a1);
    ImportsValue entity = new ImportsValue(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(ImportsValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.ImportsValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "defaultImports") + "\":") + java_util_List.marshall(a0.getDefaultImports(), a1)) + ",\"") + "wsdlImports") + "\":") + java_util_List.marshall(a0.getWSDLImports(), a1)) + "}");
  }

  private void lazyInit() {

  }
}