package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;

public class Marshaller_o_k_w_c_s_b_d_p_n_NotificationValue_1_Impl implements GeneratedMarshaller<NotificationValue> {
  private NotificationValue[] EMPTY_ARRAY = new NotificationValue[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public NotificationValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public NotificationValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NotificationValue.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("body"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("expiresAt"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("subject"), a1);
    final String c3 = java_lang_String.demarshall(obj.get("replyTo"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("type"), a1);
    final String c5 = java_lang_String.demarshall(obj.get("from"), a1);
    a1.setAssumedElementType("java.lang.String");
    final List c6 = java_util_List.demarshall(obj.get("togroups"), a1);
    a1.setAssumedElementType("java.lang.String");
    final List c7 = java_util_List.demarshall(obj.get("tousers"), a1);
    NotificationValue entity = new NotificationValue(c0, c1, c2, c3, c4, c5, c6, c7);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "groups": a1.setAssumedElementType("java.lang.String");
        entity.setGroups(java_util_List.demarshall(objVal, a1));
        break;
        case "users": a1.setAssumedElementType("java.lang.String");
        entity.setUsers(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(NotificationValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "body") + "\":") + java_lang_String.marshall(a0.getBody(), a1)) + ",\"") + "expiresAt") + "\":") + java_lang_String.marshall(a0.getExpiresAt(), a1)) + ",\"") + "from") + "\":") + java_lang_String.marshall(a0.getFrom(), a1)) + ",\"") + "groups") + "\":") + java_util_List.marshall(a0.getGroups(), a1)) + ",\"") + "replyTo") + "\":") + java_lang_String.marshall(a0.getReplyTo(), a1)) + ",\"") + "subject") + "\":") + java_lang_String.marshall(a0.getSubject(), a1)) + ",\"") + "users") + "\":") + java_util_List.marshall(a0.getUsers(), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + "}");
  }

  private void lazyInit() {

  }
}