package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AbortParent;

public class Marshaller_o_k_w_c_s_b_d_p_t_AbortParent_1_Impl implements GeneratedMarshaller<AbortParent> {
  private AbortParent[] EMPTY_ARRAY = new AbortParent[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public AbortParent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public AbortParent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AbortParent.class, objId);
    }
    final Boolean c0 = java_lang_Boolean.demarshall(obj.get("value"), a1);
    AbortParent entity = new AbortParent(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(AbortParent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.bpmn.definition.property.task.AbortParent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_lang_Boolean.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}