package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Dependencies;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.bpmn.workitem.IconDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;

public class Marshaller_o_k_w_c_s_b_w_WorkItemDefinition_1_Impl implements GeneratedMarshaller<WorkItemDefinition> {
  private WorkItemDefinition[] EMPTY_ARRAY = new WorkItemDefinition[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<IconDefinition> org_kie_workbench_common_stunner_bpmn_workitem_IconDefinition = null;
  private Marshaller<Dependencies> org_guvnor_common_services_project_model_Dependencies = null;
  public WorkItemDefinition[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public WorkItemDefinition demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(WorkItemDefinition.class, objId);
    }
    WorkItemDefinition entity = new WorkItemDefinition();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "uri": entity.setUri(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "category": entity.setCategory(java_lang_String.demarshall(objVal, a1));
        break;
        case "displayName": entity.setDisplayName(java_lang_String.demarshall(objVal, a1));
        break;
        case "documentation": entity.setDocumentation(java_lang_String.demarshall(objVal, a1));
        break;
        case "iconDefinition": entity.setIconDefinition(org_kie_workbench_common_stunner_bpmn_workitem_IconDefinition.demarshall(objVal, a1));
        break;
        case "defaultHandler": entity.setDefaultHandler(java_lang_String.demarshall(objVal, a1));
        break;
        case "parameters": entity.setParameters(java_lang_String.demarshall(objVal, a1));
        break;
        case "results": entity.setResults(java_lang_String.demarshall(objVal, a1));
        break;
        case "dependencies": entity.setDependencies(org_guvnor_common_services_project_model_Dependencies.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(WorkItemDefinition a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "uri") + "\":") + java_lang_String.marshall(a0.getUri(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "category") + "\":") + java_lang_String.marshall(a0.getCategory(), a1)) + ",\"") + "displayName") + "\":") + java_lang_String.marshall(a0.getDisplayName(), a1)) + ",\"") + "documentation") + "\":") + java_lang_String.marshall(a0.getDocumentation(), a1)) + ",\"") + "iconDefinition") + "\":") + org_kie_workbench_common_stunner_bpmn_workitem_IconDefinition.marshall(a0.getIconDefinition(), a1)) + ",\"") + "defaultHandler") + "\":") + java_lang_String.marshall(a0.getDefaultHandler(), a1)) + ",\"") + "parameters") + "\":") + java_lang_String.marshall(a0.getParameters(), a1)) + ",\"") + "results") + "\":") + java_lang_String.marshall(a0.getResults(), a1)) + ",\"") + "dependencies") + "\":") + org_guvnor_common_services_project_model_Dependencies.marshall(a0.getDependencies(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_stunner_bpmn_workitem_IconDefinition == null) {
      org_kie_workbench_common_stunner_bpmn_workitem_IconDefinition = Marshalling.getMarshaller(IconDefinition.class);
    }
    if (org_guvnor_common_services_project_model_Dependencies == null) {
      org_guvnor_common_services_project_model_Dependencies = Marshalling.getMarshaller(Dependencies.class);
    }
  }
}