package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand;

public class Marshaller_o_k_w_c_s_c_c_i_DeferredCompositeCommand_1_Impl implements GeneratedMarshaller<DeferredCompositeCommand> {
  private DeferredCompositeCommand[] EMPTY_ARRAY = new DeferredCompositeCommand[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public DeferredCompositeCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean DeferredCompositeCommand_boolean_reverse(DeferredCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand::reverse;
  }-*/;

  native static void DeferredCompositeCommand_boolean_reverse(DeferredCompositeCommand instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand::reverse = value;
  }-*/;

  native static List AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands;
  }-*/;

  native static void AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance, List<Command> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands = value;
  }-*/;

  native static boolean AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized;
  }-*/;

  native static void AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized = value;
  }-*/;

  public DeferredCompositeCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DeferredCompositeCommand.class, objId);
    }
    final Boolean c0 = java_lang_Boolean.demarshall(obj.get("reverse"), a1);
    DeferredCompositeCommand entity = new DeferredCompositeCommand(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "reverse": DeferredCompositeCommand_boolean_reverse(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "commands": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.command.Command");
        AbstractCompositeCommand_List_commands(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "initialized": AbstractCompositeCommand_boolean_initialized(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DeferredCompositeCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.command.impl.DeferredCompositeCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "reverse") + "\":") + java_lang_Boolean.marshall(DeferredCompositeCommand_boolean_reverse(a0), a1)) + ",\"") + "commands") + "\":") + java_util_List.marshall(a0.getCommands(), a1)) + ",\"") + "initialized") + "\":") + java_lang_Boolean.marshall(AbstractCompositeCommand_boolean_initialized(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}