package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.domainobject.DefaultDomainObject;

public class Marshaller_o_k_w_c_s_c_d_DefaultDomainObject_1_Impl implements GeneratedMarshaller<DefaultDomainObject> {
  private DefaultDomainObject[] EMPTY_ARRAY = new DefaultDomainObject[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DefaultDomainObject[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String DefaultDomainObject_String_uuid(DefaultDomainObject instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.domainobject.DefaultDomainObject::uuid;
  }-*/;

  native static void DefaultDomainObject_String_uuid(DefaultDomainObject instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.domainobject.DefaultDomainObject::uuid = value;
  }-*/;

  public DefaultDomainObject demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefaultDomainObject.class, objId);
    }
    DefaultDomainObject entity = new DefaultDomainObject();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "uuid": DefaultDomainObject_String_uuid(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DefaultDomainObject a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.domainobject.DefaultDomainObject") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "uuid") + "\":") + java_lang_String.marshall(DefaultDomainObject_String_uuid(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}