package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_c_d_MetadataImpl_1_Impl implements GeneratedMarshaller<MetadataImpl> {
  private MetadataImpl[] EMPTY_ARRAY = new MetadataImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public MetadataImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public native static MetadataImpl MetadataImpl__String(String a0) /*-{
    return @org.kie.workbench.common.stunner.core.diagram.MetadataImpl::new(Ljava/lang/String;)(a0);
  }-*/;

  public MetadataImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MetadataImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("definitionSetId"), a1);
    MetadataImpl entity = MetadataImpl__String(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "definitionSetId": entity.setDefinitionSetId(java_lang_String.demarshall(objVal, a1));
        break;
        case "profileId": entity.setProfileId(java_lang_String.demarshall(objVal, a1));
        break;
        case "title": entity.setTitle(java_lang_String.demarshall(objVal, a1));
        break;
        case "shapeSetId": entity.setShapeSetId(java_lang_String.demarshall(objVal, a1));
        break;
        case "canvasRootUUID": entity.setCanvasRootUUID(java_lang_String.demarshall(objVal, a1));
        break;
        case "thumbData": entity.setThumbData(java_lang_String.demarshall(objVal, a1));
        break;
        case "root": entity.setRoot((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(MetadataImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.diagram.MetadataImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "definitionSetId") + "\":") + java_lang_String.marshall(a0.getDefinitionSetId(), a1)) + ",\"") + "profileId") + "\":") + java_lang_String.marshall(a0.getProfileId(), a1)) + ",\"") + "title") + "\":") + java_lang_String.marshall(a0.getTitle(), a1)) + ",\"") + "shapeSetId") + "\":") + java_lang_String.marshall(a0.getShapeSetId(), a1)) + ",\"") + "canvasRootUUID") + "\":") + java_lang_String.marshall(a0.getCanvasRootUUID(), a1)) + ",\"") + "thumbData") + "\":") + java_lang_String.marshall(a0.getThumbData(), a1)) + ",\"") + "root") + "\":") + java_lang_Object.marshall(a0.getRoot(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {

  }
}