package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.definition.impl.PropertyImpl;
import org.kie.workbench.common.stunner.core.definition.property.PropertyType;

public class Marshaller_o_k_w_c_s_c_d_i_PropertyImpl_1_Impl implements GeneratedMarshaller<PropertyImpl> {
  private PropertyImpl[] EMPTY_ARRAY = new PropertyImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public PropertyImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean PropertyImpl_boolean_isReadOnly(PropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.definition.impl.PropertyImpl::isReadOnly;
  }-*/;

  native static void PropertyImpl_boolean_isReadOnly(PropertyImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.definition.impl.PropertyImpl::isReadOnly = value;
  }-*/;

  native static boolean PropertyImpl_boolean_isOptional(PropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.definition.impl.PropertyImpl::isOptional;
  }-*/;

  native static void PropertyImpl_boolean_isOptional(PropertyImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.definition.impl.PropertyImpl::isOptional = value;
  }-*/;

  public PropertyImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PropertyImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("id"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("caption"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("description"), a1);
    final Boolean c3 = java_lang_Boolean.demarshall(obj.get("isReadOnly"), a1);
    final Boolean c4 = java_lang_Boolean.demarshall(obj.get("isOptional"), a1);
    final Object c5 = ((ObjectMarshaller) java_lang_Object).demarshall(Object.class, obj.get("defaultValue"), a1);
    final Object c6 = ((ObjectMarshaller) java_lang_Object).demarshall(Object.class, obj.get("value"), a1);
    final PropertyType c7 = (PropertyType) ((ObjectMarshaller) java_lang_Object).demarshall(PropertyType.class, obj.get("type"), a1);
    PropertyImpl entity = new PropertyImpl(c0, c1, c2, c3, c4, c5, c6, c7);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "isReadOnly": PropertyImpl_boolean_isReadOnly(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "isOptional": PropertyImpl_boolean_isOptional(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(PropertyImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.definition.impl.PropertyImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "caption") + "\":") + java_lang_String.marshall(a0.getCaption(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "isReadOnly") + "\":") + java_lang_Boolean.marshall(PropertyImpl_boolean_isReadOnly(a0), a1)) + ",\"") + "isOptional") + "\":") + java_lang_Boolean.marshall(PropertyImpl_boolean_isOptional(a0), a1)) + ",\"") + "defaultValue") + "\":") + java_lang_Object.marshall(a0.getDefaultValue(), a1)) + ",\"") + "value") + "\":") + java_lang_Object.marshall(a0.getValue(), a1)) + ",\"") + "type") + "\":") + java_lang_Object.marshall(a0.getType(), a1)) + "}");
  }

  private void lazyInit() {

  }
}