package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.definition.property.type.IntegerType;

public class Marshaller_o_k_w_c_s_c_d_p_t_IntegerType_1_Impl implements GeneratedMarshaller<IntegerType> {
  private IntegerType[] EMPTY_ARRAY = new IntegerType[0];
  public IntegerType[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public IntegerType demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(IntegerType.class, objId);
    }
    IntegerType entity = new IntegerType();
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(IntegerType a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.definition.property.type.IntegerType") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + (((("" + ",\"") + "^InstantiateOnly") + "\":true") + "}");
  }

  private void lazyInit() {

  }
}