package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.graph.content.Bound;

public class Marshaller_o_k_w_c_s_c_g_c_Bound_1_Impl implements GeneratedMarshaller<Bound> {
  private Bound[] EMPTY_ARRAY = new Bound[0];
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  public Bound[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Bound demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Bound.class, objId);
    }
    final Double c0 = java_lang_Double.demarshall(obj.get("x"), a1);
    final Double c1 = java_lang_Double.demarshall(obj.get("y"), a1);
    Bound entity = new Bound(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(Bound a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.content.Bound") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "x") + "\":") + java_lang_Double.marshall(a0.getX(), a1)) + ",\"") + "y") + "\":") + java_lang_Double.marshall(a0.getY(), a1)) + "}");
  }

  private void lazyInit() {

  }
}