package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;

public class Marshaller_o_k_w_c_s_c_g_c_Bounds_1_Impl implements GeneratedMarshaller<Bounds> {
  private Bounds[] EMPTY_ARRAY = new Bounds[0];
  private Marshaller<Bound> org_kie_workbench_common_stunner_core_graph_content_Bound = null;
  public Bounds[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Bound Bounds_Bound_lr(Bounds instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.content.Bounds::lr;
  }-*/;

  native static void Bounds_Bound_lr(Bounds instance, Bound value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.content.Bounds::lr = value;
  }-*/;

  native static Bound Bounds_Bound_ul(Bounds instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.content.Bounds::ul;
  }-*/;

  native static void Bounds_Bound_ul(Bounds instance, Bound value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.content.Bounds::ul = value;
  }-*/;

  public Bounds demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Bounds.class, objId);
    }
    final Bound c1 = org_kie_workbench_common_stunner_core_graph_content_Bound.demarshall(obj.get("lr"), a1);
    final Bound c0 = org_kie_workbench_common_stunner_core_graph_content_Bound.demarshall(obj.get("ul"), a1);
    Bounds entity = new Bounds(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "lr": Bounds_Bound_lr(entity, org_kie_workbench_common_stunner_core_graph_content_Bound.demarshall(objVal, a1));
        break;
        case "ul": Bounds_Bound_ul(entity, org_kie_workbench_common_stunner_core_graph_content_Bound.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Bounds a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.content.Bounds") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "lr") + "\":") + org_kie_workbench_common_stunner_core_graph_content_Bound.marshall(Bounds_Bound_lr(a0), a1)) + ",\"") + "ul") + "\":") + org_kie_workbench_common_stunner_core_graph_content_Bound.marshall(Bounds_Bound_ul(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_stunner_core_graph_content_Bound == null) {
      org_kie_workbench_common_stunner_core_graph_content_Bound = Marshalling.getMarshaller(Bound.class);
    }
  }
}