package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class Marshaller_o_k_w_c_s_c_g_c_i_AddConnectorCommand_1_Impl implements GeneratedMarshaller<AddConnectorCommand> {
  private AddConnectorCommand[] EMPTY_ARRAY = new AddConnectorCommand[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public AddConnectorCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AddConnectorCommand_String_nodeUUID(AddConnectorCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand::nodeUUID;
  }-*/;

  native static void AddConnectorCommand_String_nodeUUID(AddConnectorCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand::nodeUUID = value;
  }-*/;

  native static Connection AddConnectorCommand_Connection_connection(AddConnectorCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand::connection;
  }-*/;

  native static void AddConnectorCommand_Connection_connection(AddConnectorCommand instance, Connection value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand::connection = value;
  }-*/;

  native static List AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands;
  }-*/;

  native static void AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance, List<Command<GraphCommandExecutionContext, RuleViolation>> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands = value;
  }-*/;

  native static boolean AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized;
  }-*/;

  native static void AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized = value;
  }-*/;

  public AddConnectorCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AddConnectorCommand.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("nodeUUID"), a1);
    final Edge c1 = (Edge) ((ObjectMarshaller) java_lang_Object).demarshall(Edge.class, obj.get("edge"), a1);
    final Connection c2 = (Connection) ((ObjectMarshaller) java_lang_Object).demarshall(Connection.class, obj.get("magnet"), a1);
    AddConnectorCommand entity = new AddConnectorCommand(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "nodeUUID": AddConnectorCommand_String_nodeUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "connection": AddConnectorCommand_Connection_connection(entity, (Connection) ((ObjectMarshaller) java_lang_Object).demarshall(Connection.class, objVal, a1));
        break;
        case "commands": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.command.Command");
        AbstractCompositeCommand_List_commands(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "initialized": AbstractCompositeCommand_boolean_initialized(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(AddConnectorCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.AddConnectorCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "nodeUUID") + "\":") + java_lang_String.marshall(AddConnectorCommand_String_nodeUUID(a0), a1)) + ",\"") + "edge") + "\":") + java_lang_Object.marshall(a0.getEdge(), a1)) + ",\"") + "connection") + "\":") + java_lang_Object.marshall(a0.getConnection(), a1)) + ",\"") + "commands") + "\":") + java_util_List.marshall(a0.getCommands(), a1)) + ",\"") + "initialized") + "\":") + java_lang_Boolean.marshall(AbstractCompositeCommand_boolean_initialized(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}