package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand;

public class Marshaller_o_k_w_c_s_c_g_c_i_AddNodeCommand_1_Impl implements GeneratedMarshaller<AddNodeCommand> {
  private AddNodeCommand[] EMPTY_ARRAY = new AddNodeCommand[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public AddNodeCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Node RegisterNodeCommand_Node_candidate(RegisterNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand::candidate;
  }-*/;

  native static void RegisterNodeCommand_Node_candidate(RegisterNodeCommand instance, Node value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand::candidate = value;
  }-*/;

  public AddNodeCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AddNodeCommand.class, objId);
    }
    final Node c0 = (Node) ((ObjectMarshaller) java_lang_Object).demarshall(Node.class, obj.get("candidate"), a1);
    AddNodeCommand entity = new AddNodeCommand(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "candidate": RegisterNodeCommand_Node_candidate(entity, (Node) ((ObjectMarshaller) java_lang_Object).demarshall(Node.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(AddNodeCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.AddNodeCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "candidate") + "\":") + java_lang_Object.marshall(a0.getCandidate(), a1)) + "}");
  }

  private void lazyInit() {

  }
}