package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.graph.command.impl.ClearGraphCommand;

public class Marshaller_o_k_w_c_s_c_g_c_i_ClearGraphCommand_1_Impl implements GeneratedMarshaller<ClearGraphCommand> {
  private ClearGraphCommand[] EMPTY_ARRAY = new ClearGraphCommand[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ClearGraphCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ClearGraphCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ClearGraphCommand.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("rootUUID"), a1);
    ClearGraphCommand entity = new ClearGraphCommand(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(ClearGraphCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.ClearGraphCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "rootUUID") + "\":") + java_lang_String.marshall(a0.getRootUUID(), a1)) + "}");
  }

  private void lazyInit() {

  }
}