package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class Marshaller_o_k_w_c_s_c_g_c_i_CloneConnectorCommand_1_Impl implements GeneratedMarshaller<CloneConnectorCommand> {
  private CloneConnectorCommand[] EMPTY_ARRAY = new CloneConnectorCommand[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Optional> java_util_Optional = Marshalling.getMarshaller(Optional.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public CloneConnectorCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String CloneConnectorCommand_String_sourceNodeUUID(CloneConnectorCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::sourceNodeUUID;
  }-*/;

  native static void CloneConnectorCommand_String_sourceNodeUUID(CloneConnectorCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::sourceNodeUUID = value;
  }-*/;

  native static String CloneConnectorCommand_String_targetNodeUUID(CloneConnectorCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::targetNodeUUID;
  }-*/;

  native static void CloneConnectorCommand_String_targetNodeUUID(CloneConnectorCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::targetNodeUUID = value;
  }-*/;

  native static Optional CloneConnectorCommand_Optional_callback(CloneConnectorCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::callback;
  }-*/;

  native static void CloneConnectorCommand_Optional_callback(CloneConnectorCommand instance, Optional<Consumer<Edge>> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::callback = value;
  }-*/;

  native static List AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands;
  }-*/;

  native static void AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance, List<Command<GraphCommandExecutionContext, RuleViolation>> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands = value;
  }-*/;

  native static boolean AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized;
  }-*/;

  native static void AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized = value;
  }-*/;

  public CloneConnectorCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(CloneConnectorCommand.class, objId);
    }
    final Edge c0 = (Edge) ((ObjectMarshaller) java_lang_Object).demarshall(Edge.class, obj.get("candidate"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("sourceNodeUUID"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("targetNodeUUID"), a1);
    CloneConnectorCommand entity = new CloneConnectorCommand(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "sourceNodeUUID": CloneConnectorCommand_String_sourceNodeUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "targetNodeUUID": CloneConnectorCommand_String_targetNodeUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "callback": CloneConnectorCommand_Optional_callback(entity, java_util_Optional.demarshall(objVal, a1));
        break;
        case "commands": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.command.Command");
        AbstractCompositeCommand_List_commands(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "initialized": AbstractCompositeCommand_boolean_initialized(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public native static Edge CloneConnectorCommand_getCandidate(CloneConnectorCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand::getCandidate()();
  }-*/;

  public String marshall(CloneConnectorCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "candidate") + "\":") + java_lang_Object.marshall(CloneConnectorCommand_getCandidate(a0), a1)) + ",\"") + "sourceNodeUUID") + "\":") + java_lang_String.marshall(CloneConnectorCommand_String_sourceNodeUUID(a0), a1)) + ",\"") + "targetNodeUUID") + "\":") + java_lang_String.marshall(CloneConnectorCommand_String_targetNodeUUID(a0), a1)) + ",\"") + "callback") + "\":") + java_util_Optional.marshall(CloneConnectorCommand_Optional_callback(a0), a1)) + ",\"") + "commands") + "\":") + java_util_List.marshall(a0.getCommands(), a1)) + ",\"") + "initialized") + "\":") + java_lang_Boolean.marshall(AbstractCompositeCommand_boolean_initialized(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}